
export const content = {
  en: {
    nav: {
      home: 'Home',
      about: 'About Us',
      services: 'Services',
      projects: 'Projects',
      capabilities: 'Consortium Capabilities',
      contact: 'Contact Us',
    },
    search: 'Search',
    hero: {
      title: 'UBC NOOR Consortium',
      title_line2: 'Integrated Energy & Industrial Solutions',
      subtitle:
        'Empowering Energy and Infrastructure Across the Region — from Finance to Field Execution.',
      servicesButton: 'Explore Our Services',
      contactButton: 'Contact Our Team',
      badge: 'Your Trusted Partner for Success',
      scrollIndicator: 'Scroll Down',
      features: {
        innovative: 'Innovative Solutions',
        sustainable: 'Sustainable Growth',
        international: 'International Partnerships',
      }
    },
    aboutConsortium: {
      title: 'About the Consortium',
      text: 'UBC NOOR Consortium unites international investment and engineering power — combining UBC Holding’s global infrastructure and finance capabilities with Noor Energy’s on-ground technical excellence in Iraq and the Middle East.',
    },
    noorEnergy: {
      title: 'About NOOR RENEWABLE ENERGY CO.',
      text: 'NOOR RENEWABLE ENERGY CO. is a services provider company with oil and gas and renewable energy interests in the IRAQ. The Company has working interests in two licenses containing 2 fields and a prospect. we have trained and qualified staff of engineers and technicians who can offer 24/7 services to the oil fields in instrument, control and electrical. Furthermore, our objective of is to develop affordable local high tech services for oil and gas and other industrial companies potential s, and presently the Company engages in activities ranging from Maintenance, Installation. Commissioning and startup for instrument and control systems in addition to design and supply solar energy solutions for remote industrial and commercial applications.',
      websiteButton: 'Visit Website',
    },
    noorServices: {
      title: 'Our Services',
      subtitle: 'NOOR ENERGY delivers end-to-end electrical, instrumentation, automation, and digital-oil-field solutions that boost productivity, cut maintenance costs, and enhance safety across industrial plants and energy assets.',
      badge: 'NOOR ENERGY SERVICES',
      learnMore: 'Learn More',
      items: [
        {
          title: 'Instrumentation & Controls',
          description: 'Supply, installation, loop checks, calibration, commissioning, and maintenance (pressure/temperature/DP/level/flow, tank gauging, gas detection, PLC/SCADA & SIS).',
          icon: 'CircuitBoard'
        },
        {
          title: 'Calibration Labs',
          description: 'Pressure, temperature, level (DP, radar/GWR), and flow (DP, ultrasonic, wedge) calibration services.',
          icon: 'Scaling'
        },
        {
          title: 'Automation & Control Systems',
          description: 'PLC/RTU/DCS/ESD & SCADA upgrades, PID tuning, fibre/Ethernet/industrial networks, Digital Oil Field integration, Emerson DeltaV & Honeywell Experion support.',
          icon: 'Cpu'
        },
        {
          title: 'Electrical (E&I)',
          description: 'LV/MV cabling and terminations, earthing systems, cable ladders/duct banks, lighting and small-power, LV switchgear install/retrofit, solar for remote sites.',
          icon: 'Zap'
        },
        {
          title: 'Cathodic Protection',
          description: 'Design, material supply, new/existing tank CP installation, annual surveys, remote monitoring, audits, and full lifecycle maintenance.',
          icon: 'Shield'
        },
        {
          title: 'Fire & Gas & Security',
          description: 'FM-200 clean-agent systems, F&G/PAGA/CCTV installation, commissioning, and support.',
          icon: 'ShieldCheck'
        },
        {
          title: 'IT & Cyber',
          description: 'Data/infrastructure management, secure communications, fibre-optic rollout, cybersecurity hardening for OT/IT.',
          icon: 'Globe'
        },
        {
          title: 'Renewables & ESS',
          description: 'On/Off-grid solar PV, hybrid (solar + diesel/grid), turnkey C&I energy storage (AIO liquid-cooled ESS with BMS/EMS), O&M to lower LCOE.',
          icon: 'Wind'
        },
        {
          title: 'Digital Oil Fields (DOF)',
          description: 'HMI/SCADA solutions, real-time wellhead/ESP/NFW monitoring, RTU deployments (Emerson ControlWave/Honeywell RTU2020), preventive maintenance of wireless/RTU/gateway networks.',
          icon: 'Signal'
        }
      ]
    },
    coreSectors: {
      title: 'Core Business Sectors',
      items: [
        { 
          title: 'Energy & Solar Development',
          description: 'Driving the future with large-scale renewable energy projects and sustainable power solutions.'
        },
        { 
          title: 'Oil & Gas Infrastructure',
          description: 'Building and maintaining critical infrastructure for the entire oil and gas value chain.'
        },
        { 
          title: 'Project Finance & Investment',
          description: 'Structuring and securing capital for transformative industrial and energy ventures.'
        },
        { 
          title: 'Industrial Automation & Digital Oilfields',
          description: 'Implementing cutting-edge technology to optimize efficiency and safety in industrial operations.'
        }
      ],
    },
    whyChooseUs: {
      title: "Why Choose UBC NOOR Consortium?",
      text: "We deliver integrated solutions across energy, mining, and infrastructure with unmatched expertise, from project financing to field execution. Our commitment to excellence and innovation makes us the region's most trusted partner.",
      badge: 'YOUR TRUSTED PARTNER',
      features: {
        excellence: 'Excellence',
        reliability: 'Reliability',
        innovation: 'Innovation',
        precision: 'Precision',
      },
      stats: {
        projects: 'Projects Delivered',
        experience: 'Years Experience',
        partners: 'Global Partners',
      }
    },
     whyPartnersChooseUs: {
      title: "Why Partners Choose Us",
      subtitle: "Our strategic partnerships provide mutual benefits and create value for all stakeholders in the financial ecosystem.",
      badge: "PARTNERSHIP ADVANTAGES",
      items: [
        {
          title: "Global Network Access",
          description: "Access to our extensive network of international financial partners.",
          icon: "Globe"
        },
        {
          title: "Enhanced Security",
          description: "Bank-grade security protocols and regulatory compliance.",
          icon: "ShieldCheck"
        },
        {
          title: "Advanced Technology",
          description: "Cutting-edge financial technology and analytics platforms.",
          icon: "Cpu"
        },
        {
          title: "Expert Guidance",
          description: "Professional expertise from industry-leading specialists.",
          icon: "Users"
        },
        {
          title: "Market Intelligence",
          description: "Real-time market data and comprehensive research insights.",
          icon: "AreaChart"
        },
        {
          title: "Regulatory Excellence",
          description: "Full regulatory compliance and transparent operations.",
          icon: "Landmark"
        }
      ]
    },
    aboutUs: {
        title: 'Who We Are',
        text: 'UBC NOOR Consortium is an integrated alliance founded to advance industrial and energy transformation through innovation, technology, and sustainable partnerships.',
        vision: {
            title: 'Our Vision',
            text: 'To become a regional leader in energy transition and industrial excellence.'
        },
        mission: {
            title: 'Our Mission',
            text: 'Combine global strategy (UBC Holding) with local execution (Noor Energy) to deliver energy, automation, and infrastructure projects across the region.'
        },
        values: {
            title: 'Our Values',
            items: [
                { title: 'Trust', text: 'Building lasting partnerships through integrity.' },
                { title: 'Innovation', text: 'Pioneering technology for a better future.' },
                { title: 'Integration', text: 'Synergizing global and local expertise.' },
                { title: 'Sustainability', text: 'Committing to environmental and social progress.' },
            ]
        }
    },
    capabilities: {
      title: 'Consortium Capabilities',
      subtitle:
        'By integrating UBC’s financial and logistical strengths with NOOR’s technical expertise, the consortium delivers unparalleled value across the energy sector.',
      items: [
        {
          title: 'EPC & Turnkey Solutions',
          description:
            'End-to-end management of engineering, procurement, and construction for seamless project delivery.',
        },
        {
          title: 'Project Financing & Investment Structuring',
          description:
            'Customized financial solutions and investment strategies to bring ambitious projects to life.',
        },
        {
          title: 'Energy Transition Projects',
          description:
            'Leading the shift to sustainable energy with expertise in renewables, energy storage, and grid modernization.',
        },
        {
          title: 'Smart Field Digitalization',
          description:
            'Implementing cutting-edge digital technologies to optimize oil and gas operations for efficiency and safety.',
        },
        {
          title: 'Industrial R&D and Local Partner Programs',
          description:
            'Fostering innovation and building local capacity through research, development, and strategic partnerships.',
        },
      ],
    },
    isoCertificates: {
      title: "Our Commitment to Quality",
      subtitle: "We adhere to the highest international standards, ensuring excellence and reliability in every project we undertake.",
      badge: "ISO CERTIFIED",
      certificates: [
        { name: "ISO 9001:2015", description: "Quality Management Systems" },
        { name: "ISO 14001:2015", description: "Environmental Management Systems" },
        { name: "ISO 45001:2018", description: "Occupational Health and Safety" },
      ]
    },
    partners: {
      title: 'Our Partners',
      logos: ['Honeywell', 'Stratus', 'PPS Mumbai', 'Easy Flow', 'Schneider Electric', 'UBC NRE'],
    },
    services: {
      title: 'Our Services',
      subtitle: 'We provide comprehensive and integrated solutions that meet your needs with the highest standards of quality and professionalism.',
      badge: 'Our Integrated Services',
      ubc: {
        title: 'UBC Holding Services',
        badge: 'Global Capabilities',
        learnMore: 'Learn More',
        items: [
          { title: 'Energy & Solar Projects', description: 'Leading large-scale energy generation and renewable solar initiatives.' },
          { title: 'Oil & Gas Development', description: 'Expertise in upstream, midstream, and downstream infrastructure projects.' },
          { title: 'Project Finance & Guarantees', description: 'Structuring complex financing for major industrial and energy ventures.' },
          { title: 'Mining & Metals', description: 'Developing and managing mining operations and metal processing facilities.' },
          { title: 'EPC & Lifecycle Management', description: 'End-to-end project delivery from concept to long-term maintenance.' },
        ],
      },
      noor: {
        title: 'Noor Energy Services',
        badge: 'Local Technical Expertise',
        reliability: 'High Reliability',
        specialized: 'Specialized Service',
        items: [
          { title: 'Electrical, Instrumentation & Automation', description: 'Implementing advanced E&I and automation solutions for industrial control.' },
          { title: 'PLC, SCADA, DCS Systems', description: 'Specializing in Honeywell & Emerson systems for process optimization.' },
          { title: 'Calibration & Control Systems', description: 'Ensuring precision and reliability in all control system components.' },
          { title: 'Cathodic Protection Systems', description: 'Protecting critical infrastructure from corrosion and degradation.' },
          { title: 'Renewable & Solar Energy Design', description: 'Designing efficient and sustainable solar power systems.' },
          { title: 'Commissioning & Maintenance', description: 'Expert commissioning services and long-term operational support.' },
        ],
      },
    },
    projects: {
      title: 'Our Landmark Projects',
      subtitle: 'A portfolio of successful projects demonstrating our expertise and commitment to excellence across the energy and industrial sectors.',
      badge: 'Proven Excellence',
      items: [
        {
          date: '2024–2026',
          title: 'SIBA Gas Field Maintenance Services',
          location: 'SIBA Gas Field',
          description: 'Provision of Maintenance Service for SIBA Facilities- call off Electrical and Instrumentation Call off Work orders.',
          icon: 'Fuel',
          image: 'project-image-1',
        },
        {
          date: '2025-Present',
          title: 'Engineering & Technician Services for NYCO',
          location: 'West Qurna 1',
          description: 'Provision of engineering and Technician Services and manpower for NYCO Co. in West Qurna 1.',
          icon: 'Users',
          image: 'project-image-2',
        },
        {
          date: '2025-Present',
          title: 'NICO Co. Staffing Project',
          location: 'West Qurna 2',
          description: 'Provision of engineering and Technician Services and manpower for NICO Co. in West Qurna 2.',
          icon: 'Users',
          image: 'project-image-3',
        },
        {
          date: 'April-August 2023',
          title: 'Euphrates Pumping Station Refurbishment',
          location: 'Basra',
          description: 'Complete E&I scope refurbishment for a critical water infrastructure project.',
          icon: 'Wrench',
          image: 'project-image-4',
        },
        {
          date: '2023',
          title: 'Chemical Injection Skids DS7 & DS8',
          location: 'DS7 & DS8',
          description: 'Electrical construction and installation of specialized chemical injection skids.',
          icon: 'Beaker',
          image: 'project-image-5',
        },
        {
          date: '2022–2025',
          title: 'DeltaV Wireless Wellhead Monitoring',
          location: 'Multiple Fields',
          description: 'Installation, commissioning, and maintenance of a Deltav wireless monitoring system for wellheads.',
          icon: 'Signal',
          image: 'project-image-6b',
        },
        {
          date: 'Jan-April 2022',
          title: 'Wireless Wellhead System Maintenance',
          location: 'Multiple Fields',
          description: 'Comprehensive maintenance of the wireless wellhead monitoring system.',
          icon: 'Cpu',
          image: 'project-image-7',
        },
        {
          date: 'March 2021',
          title: 'Solar-Powered Flow Meter Skids',
          location: 'Basra',
          description: 'Maintenance project for solar-powered water injection flow meters skids.',
          icon: 'Zap',
          image: 'project-image-8',
        },
        {
          date: '2025',
          title: 'DS6 Fire Water Tank Cathodic Protection',
          location: 'Al-Bilal Co. WQ-1',
          description: 'Installation of a cathodic protection system for the 2nd fire water tank at DS6.',
          icon: 'Shield',
          image: 'project-image-9',
        },
      ],
    },
    contact: {
      title: 'Get in Touch',
      description: 'We are here to help. Contact us for inquiries, collaborations, or service requests.',
      nav: {
        contact: 'Contact Us',
      },
      form: {
        title: 'Send Us a Message',
        name: 'Full Name',
        email: 'Email Address',
        company: 'Company (Optional)',
        message: 'Your Message',
        submit: 'Send Message',
      },
      locations: {
        ubc: {
          name: 'UBC Holding',
          city: 'Istanbul, Turkey',
          phone: '+90 212 663 4040',
          email: 'info@ubcholding.co',
          website: 'www.ubcholding.co',
        },
        noor: {
          name: 'Noor Energy',
          city: 'Aljazaer, Basra, Iraq',
          phone: '+964 773 806 3992',
          email: 'info@noorenergy-iq.com',
          website: 'www.noorenergy-iq.com',
        },
        consortium: {
          name: 'UBC NOOR Consortium',
          city: 'General Inquiries',
          email: 'info@ubcnoor.com',
        },
      },
      fields: {
        name: 'Full Name',
        email: 'Email Address',
        phone: 'Phone Number',
        message: 'Your Message',
      },
      button: 'Send Message',
      labels: {
        location: 'Location',
        email: 'Email',
        phone: 'Phone',
        website: 'Website',
      }
    },
    footer: {
      copyright: '© 2025 UBC HOLDING All rights reserved.',
      disclaimer: 'A UBC NOOR Consortium Venture.',
    },
  },
  ar: {
    nav: {
      home: 'الرئيسية',
      about: 'عن الشركة',
      services: 'خدماتنا',
      projects: 'مشاريعنا',
      capabilities: 'قدرات الائتلاف',
      contact: 'اتصل بنا',
    },
    search: 'بحث',
    hero: {
      title: 'ائتلاف UBC نور',
      title_line2: 'حلول متكاملة للطاقة والصناعة',
      subtitle:
        'تمكين الطاقة والبنية التحتية في جميع أنحاء المنطقة - من التمويل إلى التنفيذ الميداني.',
      servicesButton: 'اكتشف خدماتنا',
      contactButton: 'اتصل بفريقنا',
      badge: 'شريكك الموثوق في النجاح',
      scrollIndicator: 'تصفح المزيد',
      features: {
        innovative: 'حلول مبتكرة',
        sustainable: 'نمو مستدام',
        international: 'شراكات دولية',
      }
    },
    aboutConsortium: {
      title: 'عن الائتلاف',
      text: 'يجمع ائتلاف UBC نور بين القوة العالمية في الاستثمار والهندسة، حيث يدمج القدرات العالمية لشركة UBC القابضة في البنية التحتية والتمويل مع التميز الفني الميداني لشركة نور للطاقة في العراق والشرق الأوسط.',
    },
    noorEnergy: {
      title: 'عن شركة نور للطاقة المتجددة',
      text: 'شركة نور للطاقة المتجددة هي شركة مزودة للخدمات ولها اهتمامات في مجال النفط والغاز والطاقة المتجددة في العراق. تمتلك الشركة حصص تشغيل في رخصتين تحتويان على حقلين ومنطقة محتملة. لدينا فريق مدرب ومؤهل من المهندسين والفنيين الذين يمكنهم تقديم خدمات على مدار الساعة طوال أيام الأسبوع لحقول النفط في مجالات الأجهزة الدقيقة والتحكم والكهرباء. علاوة على ذلك، هدفنا هو تطوير خدمات محلية عالية التقنية وبأسعار معقولة لشركات النفط والغاز والشركات الصناعية الأخرى المحتملة، وتشارك الشركة حاليًا في أنشطة تتراوح من الصيانة والتركيب والتشغيل وبدء التشغيل لأنظمة الأجهزة والتحكم بالإضافة إلى تصميم وتوريد حلول الطاقة الشمسية للتطبيقات الصناعية والتجارية البعيدة.',
      websiteButton: 'زيارة الموقع الإلكتروني',
    },
    noorServices: {
      title: 'خدماتنا',
      subtitle: 'تقدم نور للطاقة حلولاً متكاملة في مجالات الكهرباء، والأجهزة الدقيقة، والأتمتة، وحقول النفط الرقمية، مما يعزز الإنتاجية، ويقلل تكاليف الصيانة، ويرفع مستوى السلامة في المصانع الصناعية وأصول الطاقة.',
      badge: 'خدمات نور للطاقة',
      learnMore: 'اعرف المزيد',
      items: [
        {
          title: 'الأجهزة الدقيقة والتحكم',
          description: 'توريد، تركيب، فحص الحلقات، معايرة، تشغيل وصيانة (الضغط/الحرارة/فرق الضغط/المستوى/التدفق، قياس الخزانات، كشف الغاز، PLC/SCADA و SIS).',
          icon: 'CircuitBoard'
        },
        {
          title: 'مختبرات المعايرة',
          description: 'خدمات معايرة الضغط، الحرارة، المستوى (فرق الضغط، رادار/GWR)، والتدفق (فرق الضغط، فوق صوتي، إسفين).',
          icon: 'Scaling'
        },
        {
          title: 'أنظمة الأتمتة والتحكم',
          description: 'تحديثات PLC/RTU/DCS/ESD و SCADA، ضبط PID، شبكات الألياف/الإيثرنت/الصناعية، تكامل حقول النفط الرقمية، دعم Emerson DeltaV و Honeywell Experion.',
          icon: 'Cpu'
        },
        {
          title: 'الكهرباء (E&I)',
          description: 'تمديد وإنهاء كابلات الجهد المنخفض/المتوسط، أنظمة التأريض، مسارات الكابلات/قنوات الكابلات، الإضاءة والطاقة الصغيرة، تركيب/تحديث لوحات التوزيع ذات الجهد المنخفض، الطاقة الشمسية للمواقع النائية.',
          icon: 'Zap'
        },
        {
          title: 'الحماية الكاثودية',
          description: 'تصميم، توريد مواد، تركيب حماية كاثودية للخزانات الجديدة/الحالية، مسوحات سنوية، مراقبة عن بعد، تدقيق، وصيانة كاملة لدورة الحياة.',
          icon: 'Shield'
        },
        {
          title: 'الحريق والغاز والأمن',
          description: 'أنظمة الإطفاء النظيفة FM-200، تركيب أنظمة الحريق والغاز/PAGA/CCTV، تشغيل ودعم.',
          icon: 'ShieldCheck'
        },
        {
          title: 'تقنية المعلومات والأمن السيبراني',
          description: 'إدارة البيانات/البنية التحتية، اتصالات آمنة، تمديد الألياف البصرية، تعزيز الأمن السيبراني لـ OT/IT.',
          icon: 'Globe'
        },
        {
          title: 'الطاقة المتجددة وتخزين الطاقة',
          description: 'أنظمة طاقة شمسية متصلة/غير متصلة بالشبكة، هجينة (شمسي + ديزل/شبكة)، حلول تخزين طاقة متكاملة (AIO ESS مبردة بالسائل مع BMS/EMS)، تشغيل وصيانة لخفض LCOE.',
          icon: 'Wind'
        },
        {
          title: 'حقول النفط الرقمية (DOF)',
          description: 'حلول HMI/SCADA، مراقبة فورية لرأس البئر/ESP/NFW، نشر وحدات RTU (Emerson ControlWave/Honeywell RTU2020)، صيانة وقائية للشبكات اللاسلكية/RTU/البوابات.',
          icon: 'Signal'
        }
      ]
    },
    capabilities: {
      title: 'قدرات الائتلاف',
      subtitle:
        'من خلال دمج نقاط القوة المالية واللوجستية لشركة UBC مع الخبرة الفنية لشركة نور، يقدم الائتلاف قيمة لا مثيل لها في قطاع الطاقة.',
      items: [
        {
          title: 'حلول الهندسة والمشتريات والبناء (EPC) والحلول الجاهزة',
          description:
            'إدارة شاملة للهندسة والمشتريات والبناء لتسليم المشاريع بسلاسة.',
        },
        {
          title: 'تمويل المشاريع وهيكلة الاستثمار',
          description:
            'حلول مالية مخصصة واستراتيجيات استثمارية لتحقيق المشاريع الطموحة.',
        },
        {
          title: 'مشاريع تحول الطاقة',
          description:
            'قيادة التحول إلى الطاقة المستدامة مع خبرة في الطاقة المتجددة وتخزين الطاقة وتحديث الشبكات.',
        },
        {
          title: 'رقمنة الحقول الذكية',
          description:
            'تنفيذ أحدث التقنيات الرقمية لتحسين عمليات النفط والغاز من أجل الكفاءة والسلامة.',
        },
        {
          title: 'برامج البحث والتطوير الصناعي والشركاء المحليين',
          description:
            'تعزيز الابتكار وبناء القدرات المحلية من خلال البحث والتطوير والشراكات الاستراتيجية.',
        },
      ],
    },
    coreSectors: {
      title: 'قطاعاتنا الأساسية',
      items: [
        { 
          title: 'تطوير الطاقة والطاقة الشمسية',
          description: 'قيادة المستقبل بمشاريع الطاقة المتجددة واسعة النطاق وحلول الطاقة المستدامة.'
        },
        { 
          title: 'البنية التحتية للنفط والغاز',
          description: 'بناء وصيانة البنية التحتية الحيوية لسلسلة قيمة النفط والغاز بأكملها.'
        },
        { 
          title: 'تمويل المشاريع والاستثمار',
          description: 'هيكلة وتأمين رأس المال للمشاريع الصناعية والطاقوية التحويلية.'
        },
        { 
          title: 'الأتمتة الصناعية وحقول النفط الرقمية',
          description: 'تنفيذ أحدث التقنيات لتحسين الكفاءة والسلامة في العمليات الصناعية.'
        }
      ],
    },
    whyChooseUs: {
        title: "لماذا تختار ائتلاف UBC نور؟",
        text: "نحن نقدم حلولاً متكاملة في قطاعات الطاقة والتعدين والبنية التحتية بخبرة لا مثيل لها، من تمويل المشاريع إلى التنفيذ الميداني. التزامنا بالتميز والابتكار يجعلنا الشريك الأكثر ثقة في المنطقة.",
        badge: 'شريكك الموثوق',
        features: {
          excellence: 'التميز',
          reliability: 'الموثوقية',
          innovation: 'الابتكار',
          precision: 'الدقة',
        },
        stats: {
          projects: 'مشروع ناجح',
          experience: 'سنوات من الخبرة',
          partners: 'شريك دولي',
        }
    },
    whyPartnersChooseUs: {
      title: "لماذا يختارنا الشركاء",
      subtitle: "توفر شراكاتنا الاستراتيجية منافع متبادلة وتخلق قيمة لجميع أصحاب المصلحة في النظام المالي.",
      badge: "مزايا الشراكة",
      items: [
        {
          title: "الوصول إلى الشبكة العالمية",
          description: "الوصول إلى شبكتنا الواسعة من الشركاء الماليين الدوليين.",
          icon: "Globe"
        },
        {
          title: "أمان معزز",
          description: "بروتوكولات أمان على مستوى البنوك والامتثال التنظيمي.",
          icon: "ShieldCheck"
        },
        {
          title: "تقنية متقدمة",
          description: "أحدث التقنيات المالية ومنصات التحليلات.",
          icon: "Cpu"
        },
        {
          title: "توجيه الخبراء",
          description: "خبرة مهنية من متخصصين رواد في الصناعة.",
          icon: "Users"
        },
        {
          title: "ذكاء السوق",
          description: "بيانات السوق في الوقت الفعلي ورؤى بحثية شاملة.",
          icon: "AreaChart"
        },
        {
          title: "التميز التنظيمي",
          description: "الامتثال التنظيمي الكامل والعمليات الشفافة.",
          icon: "Landmark"
        }
      ]
    },
    aboutUs: {
        title: 'من نحن',
        text: 'ائتلاف UBC نور هو تحالف متكامل تأسس لدفع التحول الصناعي والطاقوي من خلال الابتكار والتكنولوجيا والشراكات المستدامة.',
        vision: {
            title: 'رؤيتنا',
            text: 'أن نصبح رائدًا إقليميًا في تحول الطاقة والتميز الصناعي.'
        },
        mission: {
            title: 'مهمتنا',
            text: 'الجمع بين الاستراتيجية العالمية (UBC القابضة) والتنفيذ المحلي (نور للطاقة) لتقديم مشاريع الطاقة والأتمتة والبنية التحتية في جميع أنحاء المنطقة.'
        },
        values: {
            title: 'قيمنا',
            items: [
                { title: 'الثقة', text: 'بناء شراكات دائمة من خلال النزاهة.' },
                { title: 'الابتكار', text: 'ريادة التكنولوجيا من أجل مستقبل أفضل.' },
                { title: 'التكامل', text: 'تضافر الخبرات العالمية والمحلية.' },
                { title: 'الاستدامة', text: 'الالتزام بالتقدم البيئي والاجتماعي.' },
            ]
        }
    },
    isoCertificates: {
      title: "التزامنا بالجودة",
      subtitle: "نلتزم بأعلى المعايير الدولية، مما يضمن التميز والموثوقية في كل مشروع نتولاه.",
      badge: "شهادات الأيزو",
      certificates: [
        { name: "ISO 9001:2015", description: "أنظمة إدارة الجودة" },
        { name: "ISO 14001:2015", description: "أنظمة الإدارة البيئية" },
        { name: "ISO 45001:2018", description: "الصحة والسلامة المهنية" },
      ]
    },
    partners: {
      title: 'شركاؤنا',
      logos: ['Honeywell', 'Stratus', 'PPS Mumbai', 'Easy Flow', 'Schneider Electric', 'UBC NRE'],
    },
    services: {
      title: 'خدماتنا',
      subtitle: 'نقدم حلولاً شاملة ومتكاملة تلبي احتياجاتكم بأعلى معايير الجودة والاحترافية.',
      badge: 'خدماتنا المتكاملة',
      ubc: {
        title: 'خدمات UBC القابضة',
        badge: 'قدرات عالمية',
        learnMore: 'اعرف المزيد',
        items: [
          { title: 'مشاريع الطاقة والطاقة الشمسية', description: 'قيادة مشاريع توليد الطاقة واسعة النطاق ومبادرات الطاقة الشمسية المتجددة.' },
          { title: 'تطوير النفط والغاز', description: 'خبرة في مشاريع البنية التحتية للمراحل الأولية والوسطى والنهائية.' },
          { title: 'تمويل المشاريع والضمانات', description: 'هيكلة تمويل معقد للمشاريع الصناعية والطاقوية الكبرى.' },
          { title: 'التعدين والمعادن', description: 'تطوير وإدارة عمليات التعدين ومنشآt معالجة المعادن.' },
          { title: 'الهندسة والمشتريات والبناء وإدارة دورة الحياة', description: 'تسليم المشاريع من البداية إلى النهاية، من المفهوم إلى الصيانة طويلة الأجل.' },
        ],
      },
      noor: {
        title: 'خدمات نور للطاقة',
        badge: 'خبرة فنية محلية',
        reliability: 'موثوقية عالية',
        specialized: 'خدمة متخصصة',
        items: [
          { title: 'الكهرباء والأجهزة الدقيقة والأتمتة', description: 'تنفيذ حلول متقدمة في الكهرباء والأجهزة الدقيقة والأتمتة للتحكم الصناعي.' },
          { title: 'أنظمة PLC و SCADA و DCS', description: 'متخصصون في أنظمة Honeywell و Emerson لتحسين العمليات.' },
          { title: 'أنظمة المعايرة والتحكم', description: 'ضمان الدقة والموثوقية في جميع مكونات أنظمة التحكم.' },
          { title: 'أنظمة الحماية الكاثودية', description: 'حماية البنية التحتية الحيوية من التآكل والتدهور.' },
          { title: 'تصميم الطاقة المتجددة والشمسية', description: 'تصميم أنظمة طاقة شمسية فعالة ومستدامة.' },
          { title: 'التشغيل والصيانة', description: 'خدمات تشغيل متخصصة ودعم تشغيلي طويل الأجل.' },
        ],
      },
    },
    projects: {
      title: 'مشاريعنا البارزة',
      subtitle: 'مجموعة من المشاريع الناجحة التي تظهر خبرتنا والتزامنا بالتميز في قطاعي الطاقة والصناعة.',
      badge: 'التميز المثبت',
      items: [
        {
          date: '2024–2026',
          title: 'خدمات صيانة حقل السيبة للغاز',
          location: 'حقل غاز السيبة',
          description: 'توفير خدمات الصيانة لمنشآت السيبة - أوامر عمل بالطلب للكهرباء والأجهزة الدقيقة.',
          icon: 'Fuel',
          image: 'project-image-1',
        },
        {
          date: '2025 إلى الآن',
          title: 'خدمات هندسية وفنية لشركة NYCO',
          location: 'غرب القرنة 1',
          description: 'توفير خدمات هندسية وفنية وقوى عاملة لشركة NYCO في غرب القرنة 1.',
          icon: 'Users',
          image: 'project-image-2',
        },
        {
          date: '2025 إلى الآن',
          title: 'مشروع توظيف كوادر لشركة NICO',
          location: 'غرب القرنة 2',
          description: 'توفير خدمات هندسية وفنية وقوى عاملة لشركة NICO في غرب القرنة 2.',
          icon: 'Users',
          image: 'project-image-3',
        },
        {
          date: 'أبريل-أغسطس 2023',
          title: 'تجديد محطة ضخ الفرات',
          location: 'البصرة',
          description: 'نطاق عمل كامل لتجديد الأجهزة الكهربائية والدقيقة لمشروع بنية تحتية مائية حيوية.',
          icon: 'Wrench',
          image: 'project-image-4',
        },
        {
          date: '2023',
          title: 'منصات حقن الكيماويات DS7 و DS8',
          location: 'DS7 & DS8',
          description: 'أعمال البناء والتركيبات الكهربائية لمنصات حقن كيماويات متخصصة.',
          icon: 'Beaker',
          image: 'project-image-5',
        },
        {
          date: '2022–2025',
          title: 'مراقبة لاسلكية لآبار النفط بنظام DeltaV',
          location: 'حقول متعددة',
          description: 'تركيب وتشغيل وصيانة نظام مراقبة لاسلكي من نوع DeltaV لرؤوس الآبار.',
          icon: 'Signal',
          image: 'project-image-6',
        },
        {
          date: 'يناير-أبريل 2022',
          title: 'صيانة نظام مراقبة الآبار اللاسلكي',
          location: 'حقول متعددة',
          description: 'صيانة شاملة لنظام مراقبة رؤوس الآبار اللاسلكي.',
          icon: 'Cpu',
          image: 'project-image-7',
        },
        {
          date: 'مارس 2021',
          title: 'منصات قياس التدفق تعمل بالطاقة الشمسية',
          location: 'البصرة',
          description: 'مشروع صيانة لمنصات قياس تدفق حقن المياه التي تعمل بالطاقة الشمسية.',
          icon: 'Zap',
          image: 'project-image-8',
        },
        {
          date: '2025',
          title: 'حماية كاثودية لخزان مياه الإطفاء في DS6',
          location: 'شركة بلال، غرب القرنة 1',
          description: 'تركيب نظام حماية كاثودية لخزان مياه الإطفاء الثاني في DS6.',
          icon: 'Shield',
          image: 'project-image-9',
        },
      ],
    },
    contact: {
      title: 'تواصل معنا',
      description: 'نحن هنا للمساعدة. اتصل بنا للاستفسارات أو التعاون أو طلبات الخدمة.',
      nav: {
        contact: 'اتصل بنا',
      },
      form: {
        title: 'أرسل لنا رسالة',
        name: 'الاسم الكامل',
        email: 'البريد الإلكتروني',
        company: 'الشركة (اختياري)',
        message: 'رسالتك',
        submit: 'إرسال الرسالة',
      },
      locations: {
        ubc: {
          name: 'UBC القابضة',
          city: 'اسطنبول، تركيا',
          phone: '+90 212 663 4040',
          email: 'info@ubcholding.co',
          website: 'www.ubcholding.co',
        },
        noor: {
          name: 'نور للطاقة',
          city: 'الجزائر، البصرة، العراق',
          phone: '+964 773 806 3992',
          email: 'info@noorenergy-iq.com',
          website: 'www.noorenergy-iq.com',
        },
        consortium: {
          name: 'ائتلاف UBC نور',
          city: 'استفسارات عامة',
          email: 'info@ubcnoor.com',
        },
      },
      fields: {
        name: 'الاسم الكامل',
        email: 'البريد الإلكتروني',
        phone: 'رقم الهاتف',
        message: 'رسالتك',
      },
      button: 'إرسال الرسالة',
      labels: {
        location: 'الموقع',
        email: 'البريد الإلكتروني',
        phone: 'الهاتف',
        website: 'الموقع الإلكتروني',
      },
    },
    footer: {
      copyright: '© 2025 UBC القابضة. جميع الحقوق محفوظة.',
      disclaimer: 'مشروع مشترك لائتلاف UBC نور.',
    },
  },
};

    

    

  
